<#ibiztemplate>
TARGET=PSAPPDEUILOGIC
</#ibiztemplate>
import { UIActionContext } from "@/logic/uiaction-context";
import { BeginNode, EndNode, AppendParamNode } from "@/logic/logic-node";

/**
 * ${item.name}
 *
 * @export
 * @class ${srfclassname('${item.getCodeName()}')}UILogicBase
 */
export default class ${srfclassname('${item.getCodeName()}')}UILogicBase {

    /**
     * Creates an instance of  ${item.codeName}Base.
     * 
     * @param {*} [opts={}]
     * @memberof  ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    constructor(opts: any = {}) { }

    protected readonly startLogicNode: string = '<#if item.getStartPSDEUILogicNode?? && item.getStartPSDEUILogicNode()??>${item.getStartPSDEUILogicNode().codeName}</#if>';

    protected logicParams: any[] = [
<#if item.getPSDEUILogicParams?? && item.getPSDEUILogicParams()??>
    <#list item.getPSDEUILogicParams() as logicParam>
        {
            name: '${logicParam.name}',
            codeName: '${logicParam.codeName}',
            default: <#if logicParam.isDefault?? && logicParam.isDefault()>true<#else>false</#if>,
            navContextParam: <#if logicParam.isNavContextParam?? && logicParam.isNavContextParam()>true<#else>false</#if>,
            navViewParamParam: <#if logicParam.isNavViewParamParam?? && logicParam.isNavViewParamParam()>true<#else>false</#if>,
            activeContainerParam: <#if logicParam.isActiveContainerParam?? && logicParam.isActiveContainerParam()>true<#else>false</#if>,
            activeCtrlParam: <#if logicParam.isActiveCtrlParam?? && logicParam.isActiveCtrlParam()>true<#else>false</#if>,
            activeViewParam: <#if logicParam.isActiveViewParam?? && logicParam.isActiveViewParam()>true<#else>false</#if>,
            lastReturnParam: <#if logicParam.isLastReturnParam?? && logicParam.isLastReturnParam()>true<#else>false</#if>
        },
    </#list>
</#if>
    ];


    protected logicNodes: ILogicNode[] = [
<#if item.getPSDEUILogicNodes?? && item.getPSDEUILogicNodes()??>
    <#list item.getPSDEUILogicNodes() as logicNode>
        <#assign node>
        codeName: '${logicNode.codeName}',
        name: '${logicNode.name}',
        logicNodeType: '${logicNode.getLogicNodeType()}',
        <#if logicNode.getDstPSDEUILogicParam?? && logicNode.getDstPSDEUILogicParam()??>
        dstParam: '${logicNode.getDstPSDEUILogicParam().codeName}',
        </#if>
        <#if logicNode.getDstIndex?? && logicNode.getDstIndex()??>
        dstIndex: '${logicNode.getDstIndex()?c}',
        </#if>
        <#if logicNode.getSrcPSDEUILogicParam?? && logicNode.getSrcPSDEUILogicParam()??>
        srcParam: '${logicNode.getSrcPSDEUILogicParam().codeName}',
        </#if>
        <#if logicNode.getSrcFieldName?? && logicNode.getSrcFieldName()??>
        srcFieldName: '${logicNode.getSrcFieldName()}',
        </#if>
        <#if logicNode.getSrcIndex?? && logicNode.getSrcIndex()??>
        srcIndex: '${logicNode.getSrcIndex()?c}',
        </#if>
        <#if logicNode.getSrcSize?? && logicNode.getSrcSize()??>
        srcSize: '${logicNode.getSrcSize()?c}',
        </#if>
        <#if logicNode.getReturnParam?? && logicNode.getReturnParam()??>
        returnParam: '${logicNode.getReturnParam().codeName}',
        </#if>
        <#if logicNode.getReturnType?? && logicNode.getReturnType()??>
        returnType: '${logicNode.getReturnType()}',
        </#if>
        <#if logicNode.getRawValue?? && logicNode.getRawValue()??>
        returnRawValue: '${logicNode.getRawValue()}',
        </#if>
        <#if logicNode.getPSDEUILogicLinks?? && logicNode.getPSDEUILogicLinks()??>
        logicLinks: [
            <#list logicNode.getPSDEUILogicLinks() as link>
            {
                name: '${link.name}',
                dstLogicNode: '${link.getDstPSDEUILogicNode().codeName}',
                <#if link.getPSDEUILogicLinkGroupCond?? && link.getPSDEUILogicLinkGroupCond()??>
                //  逻辑连接暂未支持
                linkGroupCond: [],
                </#if>
            }
            </#list>
        ]
        </#if>
        </#assign>
        <@compress single_line=true>{ ${node} },</@compress>
    </#list>
</#if>
    ];

    public beforeExecute(args: any, context: any = {}, params: any = {},
        $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        return new UIActionContext(this.logicParams, args, context, params, $event, xData, actioncontext, srfParentDeName)
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof GridViewLoadUILogicBase
     */
    async execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actioncontext?: any, srfParentDeName?: string) {
        try {
            const actionContext = this.beforeExecute(args, context, params, $event, xData, actioncontext, srfParentDeName);
            const startNode = this.logicNodes.find((logicNode: ILogicNode) => logicNode.codeName === this.startLogicNode);
            if (!startNode) {
                throw new Error('没有开始节点');
            }
            await this.executeNode(startNode, actionContext);
            return actionContext.getResult();
        } catch (error: any) {
            <#noparse>throw new Error(`${error && error.message ? error.message : '发生未知错误！'}`);</#noparse>
        }
    }

    executeNode(logicNode: ILogicNode, actionContext: UIActionContext) {
        try {
            switch (logicNode.logicNodeType) {
                case 'BEGIN':
                    console.log(111, '执行开始节点');
                    break;
                case 'END':
                    console.log(111, '执行结束节点');
                    break;
            }
        } catch (error: any) {

        }
    }


}